/*------------------------------------------------------------------------------*
 * File Name:				 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/

#include <Dialog.h>        // Dialog class, Control.h, etc.
#include "ActiveXDLG.h"    // Resource IDs
///Sophy 11/11/2011 ORG-4354 ACATIVEX_DIALOG_USE_WXGRID_CONTROL
#include <..\Originlab\DialogEx.h>
#include <TreeEditor.h>
///end ACATIVEX_DIALOG_USE_WXGRID_CONTROL
#define AXD_NUM_COLS    2
#define AXD_NUM_ROWS    12

class CActiveXDlg : public Dialog
{
public:
	CActiveXDlg() : Dialog(IDD_AXD_ACTIVEX_DLG, "ActiveXDLG" )
	{
		
	}
	
	virtual int  DoModal(HWND hParent = NULL)
	{
		InitMsgMap();
		int nRet = Dialog::DoModal(hParent);
		return nRet;
	}
	
protected:
	
EVENTS_BEGIN
	ON_INIT( OnInitDialog )
	ON_BN_CLICKED( IDC_AXD_COMPUTE_BTN, OnClickComputeBTN )	
	ON_ACTIVEX_EVENT(21, IDC_AXD_VSFLEXGRID, OnBeforeEdit,  VTS_CTRL VTS_I4 VTS_I4 VTS_PBOOL)
EVENTS_END	
	
	// *** Event handler to initialize dialog ***
	BOOL OnInitDialog()
	{
		// ** Initialize grid **
		///Sophy 11/11/2011 ORG-4354 ACATIVEX_DIALOG_USE_WXGRID_CONTROL
		//Control ctrl = GetItem( IDC_AXD_VSFLEXGRID );
		//m_objActiveX = ctrl.GetActiveXControl();	
		TreeGridControl		gridCntrl = GetDlgItem(IDC_AXD_VSFLEXGRID);
		m_objActiveX = gridCntrl.GetGridCtrlInterface();
		///end ACATIVEX_DIALOG_USE_WXGRID_CONTROL
		
		m_objActiveX.Cols = AXD_NUM_COLS;        // Set number of columns
		m_objActiveX.Rows = AXD_NUM_ROWS;        // Set number of rows
	
		m_objActiveX.FixedCols = 0;              // Hides row headings
		m_objActiveX.FixedRows = 1;              // One fixed row for column headings
	
		m_objActiveX.Row = 0;                    // Set Col 0 heading
		m_objActiveX.Col = 0;
		m_objActiveX.Text = (string)"Data";
	
		m_objActiveX.Col = 1;					// Set Col 1 heading
		m_objActiveX.Text = (string)"Include";	
	
		m_objActiveX.Editable = 2;               // Make grid editable in GUI
		
		// ** Initialize column values in grid **
		for(int ii = 1; ii < AXD_NUM_ROWS - 1; ii++)
		{
			m_objActiveX.Row = ii;
			m_objActiveX.Col = 0;
			m_objActiveX.Text = ii;              // Initialize Col 0 to integers 1 to 10
			m_objActiveX.Col = 1;
			//m_objActiveX.CellChecked = 1;        // Make all cells in Col 1 be checkboxes and checked by default
			m_objActiveX.SetCell(1, flexcpChecked, ii, 1);	///Sophy 11/11/2011 ORG-4354 ACATIVEX_DIALOG_USE_WXGRID_CONTROL
		}
	
		// ** Format last row that contains sums ** 
		m_objActiveX.Row = ii;
		m_objActiveX.Col = 0;
		///Sophy 11/11/2011 ORG-4354 ACATIVEX_DIALOG_USE_WXGRID_CONTROL
		//m_objActiveX.CellBackColor = RGB( 72, 216, 56 );
		m_objActiveX.SetCell(RGB( 72, 216, 56 ), flexcpBackColor, ii, 0);
		///end ACATIVEX_DIALOG_USE_WXGRID_CONTROL
		m_objActiveX.Col = 1;
		///Sophy 11/11/2011 ORG-4354 ACATIVEX_DIALOG_USE_WXGRID_CONTROL
		//m_objActiveX.CellBackColor = RGB( 72, 216, 56 );
		m_objActiveX.SetCell(RGB( 72, 216, 56 ), flexcpBackColor, ii, 1);
		///end ACATIVEX_DIALOG_USE_WXGRID_CONTROL
		
		return TRUE;
	}
	
	
	// *** Event handler for OnClick of Compute button ***
	BOOL OnClickComputeBTN( Control ctrl )
	{		
		// ** Compute sum **
		double dSum = 0;
		int nChecks = 0;
		for( int ii = 1; ii < AXD_NUM_ROWS - 1; ii++ )
		{
			m_objActiveX.Row = ii;
			m_objActiveX.Col = 1;
			///Sophy 11/11/2011 ORG-4354 ACATIVEX_DIALOG_USE_WXGRID_CONTROL
			//if( m_objActiveX.CellChecked == 1 )
			if ( 1 == m_objActiveX.GetCell(flexcpChecked, ii, 1) )
			///end ACATIVEX_DIALOG_USE_WXGRID_CONTROL
			{
				nChecks += 1;
				m_objActiveX.Col = 0;
				///Sophy 11/11/2011 ORG-4354 ACATIVEX_DIALOG_USE_WXGRID_CONTROL
				//dSum += m_objActiveX.Value;
				string strVal = m_objActiveX.GetCell(flexcpText, ii, 0);
				dSum += atof(strVal);
				///end ACATIVEX_DIALOG_USE_WXGRID_CONTROL
			}
		}
		
		// ** Output sums in last row of grid **
		m_objActiveX.Row = ii;
		m_objActiveX.Col = 0;
		m_objActiveX.Text = dSum;
		m_objActiveX.Col = 1;
		m_objActiveX.Text = nChecks;
		
		return TRUE;
	}
	
	
	// ActiveX event handling	
	void OnBeforeEdit(Control cntrl, long nRow, long nCol, BOOL* pCancel)
	{		
		string strCombo = "1|2|3|4|5|6|7";
		string strNormalEdit = "";
	
		if(nRow > 9) // row 1-9 can edit, row 10 and up we show how to disable editing 
		{
			*pCancel = TRUE;
			return;
		}
		
		if(nCol == 0 && nRow > 5) // some rows we use combo box, some we don't
			m_objActiveX.ComboList = strCombo;
		else
			m_objActiveX.ComboList = strNormalEdit;	
	}
	
private:
	///Sophy 11/11/2011 ORG-4354 ACATIVEX_DIALOG_USE_WXGRID_CONTROL
	//Object m_objActiveX;	// Define vsFlexGrid member variable 
	wxGirdInterface m_objActiveX;	// Define vsFlexGrid member variable 
	///end ACATIVEX_DIALOG_USE_WXGRID_CONTROL

};